<?php
require_once __DIR__ . '/includes/auth.php'; require_login();
$clients = $pdo->query("SELECT id, name, address FROM clients ORDER BY name")->fetchAll();
$plans = $pdo->query("SELECT p.id, p.name AS plan, s.name AS subscription FROM plans p JOIN subscriptions s ON s.id=p.subscription_id ORDER BY s.name, p.name")->fetchAll();
function calc_prorata($rate, $from, $to){
  if(!$rate || !$from || !$to) return 0;
  $fromD = new DateTime($from); $toD = new DateTime($to);
  if($toD < $fromD) return 0;
  $days = $fromD->diff($toD)->days + 1;
  $den = 365;
  for($y=intval($fromD->format('Y')); $y<=intval($toD->format('Y')); $y++){
    if (checkdate(2,29,$y)) { $feb29 = new DateTime("$y-02-29"); if($feb29 >= $fromD && $feb29 <= $toD){ $den=366; break; } }
  }
  return round($rate * ($days / $den));
}
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $id = intval($_POST['id'] ?? 0); $client_id = intval($_POST['client_id'] ?? 0); $plan_id = intval($_POST['plan_id'] ?? 0);
  $rate = floatval($_POST['rate'] ?? 0); $from = $_POST['from_date'] ?? ''; $to = $_POST['to_date'] ?? ''; $notes = trim($_POST['notes'] ?? '');
  if($client_id && $plan_id && $rate>0 && $from && $to && $from <= $to){
    $prorata = calc_prorata($rate, $from, $to);
    if($id){ $stmt=$pdo->prepare("UPDATE memos SET client_id=?, plan_id=?, rate=?, from_date=?, to_date=?, prorata=?, notes=? WHERE id=?"); $stmt->execute([$client_id,$plan_id,$rate,$from,$to,$prorata,$notes,$id]); }
    else { $stmt=$pdo->prepare("INSERT INTO memos (client_id, plan_id, rate, from_date, to_date, prorata, notes, created_by_user_id) VALUES (?,?,?,?,?,?,?,?)"); $stmt->execute([$client_id,$plan_id,$rate,$from,$to,$prorata,$notes,current_user_id()]); }
  }
  header('Location: /transaction.php'); exit;
}
if (isset($_GET['del'])) { $pdo->prepare("DELETE FROM memos WHERE id=?")->execute([intval($_GET['del'])]); header('Location: /transaction.php'); exit; }
$rows = $pdo->query("SELECT m.*, c.name AS client, c.address, p.name AS plan, s.name AS subscription, u.username AS created_by
  FROM memos m JOIN clients c ON c.id=m.client_id JOIN plans p ON p.id=m.plan_id JOIN subscriptions s ON s.id=p.subscription_id LEFT JOIN users u ON u.id=m.created_by_user_id ORDER BY m.id DESC")->fetchAll();
include __DIR__ . '/includes/header.php'; ?>
<h1 class="h5">Transaction – Memo</h1>
<div class="card mb-3"><div class="card-body">
<form method="post" class="row g-3">
  <input type="hidden" name="id">
  <div class="col-md-4"><label class="form-label">Client *</label><select class="form-select" name="client_id" required><option value="">-- Select --</option>
    <?php foreach($clients as $c): ?><option value="<?php echo $c['id']; ?>"><?php echo htmlspecialchars($c['name']); ?></option><?php endforeach; ?></select></div>
  <div class="col-md-4"><label class="form-label">Plan *</label><select class="form-select" name="plan_id" required><option value="">-- Select --</option>
    <?php foreach($plans as $p): ?><option value="<?php echo $p['id']; ?>"><?php echo htmlspecialchars($p['plan']." (".$p['subscription'].")"); ?></option><?php endforeach; ?></select></div>
  <div class="col-md-2"><label class="form-label">Rate (₹) *</label><input type="number" step="0.01" min="0.01" class="form-control" name="rate" required></div>
  <div class="col-md-1"><label class="form-label">From *</label><input type="date" class="form-control" name="from_date" required></div>
  <div class="col-md-1"><label class="form-label">To *</label><input type="date" class="form-control" name="to_date" required></div>
  <div class="col-12"><label class="form-label">Notes</label><input class="form-control" name="notes"></div>
  <div class="col-12 d-grid"><button class="btn btn-primary" type="submit">Save Memo</button></div>
</form>
</div></div>
<div class="card"><div class="card-body">
<div class="table-responsive"><table class="table table-striped align-middle"><thead><tr><th>#</th><th>Client</th><th>Address</th><th>Plan</th><th>Subscription</th><th>Rate</th><th>From → To</th><th>Prorata</th><th>Added By</th><th>Action</th></tr></thead><tbody>
<?php $i=1; foreach($rows as $r): ?><tr>
<td><?php echo $i++; ?></td><td><?php echo htmlspecialchars($r['client']); ?></td><td><?php echo htmlspecialchars($r['address']); ?></td>
<td><?php echo htmlspecialchars($r['plan']); ?></td><td><?php echo htmlspecialchars($r['subscription']); ?></td>
<td><?php echo number_format($r['rate'],2); ?></td><td><?php echo htmlspecialchars($r['from_date'])." → ".htmlspecialchars($r['to_date']); ?></td>
<td><?php echo number_format($r['prorata'],0); ?></td><td><?php echo htmlspecialchars($r['created_by']); ?></td>
<td><a class="btn btn-sm btn-outline-danger" href="/transaction.php?del=<?php echo $r['id']; ?>" onclick="return confirm('Delete?')">Delete</a></td>
</tr><?php endforeach; ?>
</tbody></table></div></div></div>
<?php include __DIR__ . '/includes/footer.php'; ?>
