<?php
require_once __DIR__ . '/includes/auth.php'; require_login();
function overlaps($aFrom,$aTo,$bFrom,$bTo){ return $aFrom <= $bTo && $aTo >= $bFrom; }
$clients = $pdo->query("SELECT id, name FROM clients ORDER BY name")->fetchAll();
$subs = $pdo->query("SELECT DISTINCT s.name FROM subscriptions s ORDER BY s.name")->fetchAll(PDO::FETCH_COLUMN);
$plans = $pdo->query("SELECT DISTINCT p.name FROM plans p ORDER BY p.name")->fetchAll(PDO::FETCH_COLUMN);
$yr = intval(date('Y')); $from = $_GET['from'] ?? "$yr-01-01"; $to = $_GET['to'] ?? "$yr-12-31";
$client_id = intval($_GET['client_id'] ?? 0); $sub_filter = $_GET['subscription'] ?? ''; $plan_filter = $_GET['plan'] ?? '';
$memos = $pdo->query("SELECT m.*, u.username created_by, c.name client, p.name plan, s.name subscription FROM memos m JOIN users u ON u.id=m.created_by_user_id JOIN clients c ON c.id=m.client_id JOIN plans p ON p.id=m.plan_id JOIN subscriptions s ON s.id=p.subscription_id")->fetchAll();
include __DIR__ . '/includes/header.php'; ?>
<h1 class="h5">Reports</h1>
<div class="card mb-3"><div class="card-body">
<form class="row g-2" method="get">
  <div class="col-md-3"><label class="form-label">From</label><input type="date" class="form-control" name="from" value="<?php echo htmlspecialchars($from); ?>"></div>
  <div class="col-md-3"><label class="form-label">To</label><input type="date" class="form-control" name="to" value="<?php echo htmlspecialchars($to); ?>"></div>
  <div class="col-md-3"><label class="form-label">Client</label><select class="form-select" name="client_id"><option value="0">All</option>
    <?php foreach($clients as $c): ?><option value="<?php echo $c['id']; ?>" <?php if($client_id==$c['id']) echo 'selected'; ?>><?php echo htmlspecialchars($c['name']); ?></option><?php endforeach; ?>
  </select></div>
  <div class="col-md-3"><label class="form-label">Subscription</label><select class="form-select" name="subscription"><option value="">All</option>
    <?php foreach($subs as $s): ?><option <?php if($sub_filter===$s) echo 'selected'; ?>><?php echo htmlspecialchars($s); ?></option><?php endforeach; ?>
  </select></div>
  <div class="col-md-3"><label class="form-label">Plan</label><select class="form-select" name="plan"><option value="">All</option>
    <?php foreach($plans as $p): ?><option <?php if($plan_filter===$p) echo 'selected'; ?>><?php echo htmlspecialchars($p); ?></option><?php endforeach; ?>
  </select></div>
  <div class="col-md-2 d-grid align-self-end"><button class="btn btn-primary" type="submit">Run</button></div>
</form></div></div>
<div class="row g-3">
  <div class="col-12"><div class="card"><div class="card-body">
    <h6 class="mb-3">Subscription-Wise (Revenue)</h6>
    <div class="table-responsive"><table class="table table-striped align-middle"><thead><tr><th>#</th><th>Subscription</th><th class="text-end"># Memos</th><th class="text-end">Revenue (₹)</th></tr></thead><tbody>
      <?php $agg=[]; foreach($memos as $m){ if(!overlaps($m['from_date'],$m['to_date'],$from,$to)) continue; if($client_id && $m['client_id']!=$client_id) continue; if($sub_filter && $m['subscription']!==$sub_filter) continue; $k=$m['subscription']; if(!isset($agg[$k])) $agg[$k]=['memos'=>0,'rev'=>0]; $agg[$k]['memos']+=1; $agg[$k]['rev']+=$m['prorata']; }
      $i=1; $total=0; foreach($agg as $k=>$v){ $total+=$v['rev']; echo "<tr><td>".($i++)."</td><td>".htmlspecialchars($k)."</td><td class='text-end'>{$v['memos']}</td><td class='text-end'>".number_format($v['rev'],0)."</td></tr>"; } if(!$agg) echo "<tr><td colspan='4' class='text-muted'>No data.</td></tr>"; ?>
    </tbody><tfoot><tr><th colspan="3" class="text-end">Total</th><th class="text-end"><?php echo number_format($total,0); ?></th></tr></tfoot></table></div>
  </div></div></div>
  <div class="col-12"><div class="card"><div class="card-body">
    <h6 class="mb-3">Plan-Wise Revenue</h6>
    <div class="table-responsive"><table class="table table-striped align-middle"><thead><tr><th>#</th><th>Plan</th><th>Subscription</th><th class="text-end"># Memos</th><th class="text-end">Revenue (₹)</th></tr></thead><tbody>
      <?php $agg=[]; foreach($memos as $m){ if(!overlaps($m['from_date'],$m['to_date'],$from,$to)) continue; if($client_id && $m['client_id']!=$client_id) continue; if($plan_filter && $m['plan']!==$plan_filter) continue; $k=$m['plan'].'||'.$m['subscription']; if(!isset($agg[$k])) $agg[$k]=['plan'=>$m['plan'],'subscription'=>$m['subscription'],'memos'=>0,'rev'=>0]; $agg[$k]['memos']+=1; $agg[$k]['rev']+=$m['prorata']; }
      $i=1; $total=0; foreach($agg as $k=>$v){ $total+=$v['rev']; echo "<tr><td>".($i++)."</td><td>".htmlspecialchars($v['plan'])."</td><td>".htmlspecialchars($v['subscription'])."</td><td class='text-end'>{$v['memos']}</td><td class='text-end'>".number_format($v['rev'],0)."</td></tr>"; } if(!$agg) echo "<tr><td colspan='5' class='text-muted'>No data.</td></tr>"; ?>
    </tbody><tfoot><tr><th colspan="4" class="text-end">Total</th><th class="text-end"><?php echo number_format($total,0); ?></th></tr></tfoot></table></div>
  </div></div></div>
</div>
<?php include __DIR__ . '/includes/footer.php'; ?>
