<?php
require_once __DIR__ . '/includes/auth.php'; require_login();
$subs = $pdo->query("SELECT id, name FROM subscriptions ORDER BY name")->fetchAll();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $id = intval($_POST['id'] ?? 0); $subscription_id = intval($_POST['subscription_id'] ?? 0); $name = trim($_POST['name'] ?? '');
  if ($subscription_id && $name) { if ($id) { $pdo->prepare("UPDATE plans SET subscription_id=?, name=? WHERE id=?")->execute([$subscription_id,$name,$id]); }
    else { $pdo->prepare("INSERT INTO plans (subscription_id, name, created_by_user_id) VALUES (?,?,?)")->execute([$subscription_id,$name,current_user_id()]); } }
  header('Location: /plan.php'); exit;
}
if (isset($_GET['del'])) { $pdo->prepare("DELETE FROM plans WHERE id=?")->execute([intval($_GET['del'])]); header('Location: /plan.php'); exit; }
$rows = $pdo->query("SELECT p.*, s.name AS subscription, u.username as created_by FROM plans p JOIN subscriptions s ON s.id=p.subscription_id LEFT JOIN users u ON u.id=p.created_by_user_id ORDER BY s.name, p.name")->fetchAll();
include __DIR__ . '/includes/header.php'; ?>
<h1 class="h5">Plans by Subscription</h1>
<div class="card mb-3"><div class="card-body">
<form method="post" class="row g-3">
  <input type="hidden" name="id">
  <div class="col-md-5"><label class="form-label">Subscription *</label><select class="form-select" name="subscription_id" required>
    <option value="">-- Select --</option><?php foreach($subs as $s): ?><option value="<?php echo $s['id']; ?>"><?php echo htmlspecialchars($s['name']); ?></option><?php endforeach; ?></select></div>
  <div class="col-md-5"><label class="form-label">Plan *</label><input class="form-control" name="name" required></div>
  <div class="col-md-2 d-grid align-self-end"><button class="btn btn-primary" type="submit">Save</button></div>
</form></div></div>
<div class="card"><div class="card-body">
<table class="table table-striped align-middle"><thead><tr><th>#</th><th>Subscription</th><th>Plan</th><th>Created By</th><th>Action</th></tr></thead><tbody>
<?php $i=1; foreach($rows as $r): ?><tr><td><?php echo $i++; ?></td><td><?php echo htmlspecialchars($r['subscription']); ?></td><td><?php echo htmlspecialchars($r['name']); ?></td><td><?php echo htmlspecialchars($r['created_by']); ?></td>
<td><a class="btn btn-sm btn-outline-danger" href="/plan.php?del=<?php echo $r['id']; ?>" onclick="return confirm('Delete?')">Delete</a></td></tr><?php endforeach; ?>
</tbody></table></div></div>
<?php include __DIR__ . '/includes/footer.php'; ?>
