<?php
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/vendor/autoload.php'; // composer require phpmailer/phpmailer
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

$msg=null; $err=null;
if($_SERVER['REQUEST_METHOD']==='POST'){
  $username = trim($_POST['username'] ?? '');
  if(!$username){ $err='Username is required.'; }
  else {
    $stmt=$pdo->prepare("SELECT * FROM users WHERE username=?"); $stmt->execute([$username]); $user=$stmt->fetch();
    if(!$user || empty($user['email'])){ $err='User not found or no email set.'; }
    else {
      $token = bin2hex(random_bytes(16));
      $link = sprintf("%s/reset_password.php?u=%s&t=%s", (isset($_SERVER['HTTPS'])?'https':'http').'://'.$_SERVER['HTTP_HOST'], urlencode($username), $token);
      try{
        $mail = new PHPMailer(true);
        $mail->isSMTP();
        $mail->Host = $SMTP_HOST; $mail->Port = $SMTP_PORT; $mail->SMTPAuth = true;
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Username = $SMTP_USER; $mail->Password = $SMTP_PASS;
        $mail->setFrom($SMTP_FROM_EMAIL, $SMTP_FROM_NAME);
        $mail->addAddress($user['email'] ?: $SMTP_FROM_EMAIL);
        $mail->Subject = 'Password Reset';
        $mail->Body = "Hello {$username},\n\nClick to reset your password: {$link}\n\nIf you did not request this, ignore.";
        $mail->send();
        $msg='Password reset email sent to: '.htmlspecialchars($user['email']);
      } catch (Exception $e){ $err = 'Mailer Error: '.$mail->ErrorInfo; }
    }
  }
}
?><!doctype html><html><head><meta charset="utf-8"/><meta name="viewport" content="width=device-width, initial-scale=1"/>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"/>
<title>Forgot Password</title></head><body class="bg-light"><div class="container py-5"><div class="row justify-content-center"><div class="col-md-5">
<div class="card shadow-sm"><div class="card-body"><h1 class="h5 mb-3">Forgot Password</h1>
<?php if($msg): ?><div class="alert alert-success"><?php echo $msg; ?></div><?php endif; ?>
<?php if($err): ?><div class="alert alert-danger"><?php echo $err; ?></div><?php endif; ?>
<form method="post"><div class="mb-3"><label class="form-label">Username</label><input class="form-control" name="username" required></div>
<div class="d-grid"><button class="btn btn-primary" type="submit">Send Reset Email</button></div>
<div class="mt-3"><a href="/login.php">Back to login</a></div></form></div></div>
</div></div></div></body></html>
